/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.explosion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.network.BombExplosionKnockbackPacket;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EntityExplosionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BombExplosion
extends Explosion {
    private final Entity source;
    private final float radius;
    private final World level;
    private final double x;
    private final double y;
    private final double z;
    private final boolean blue;
    private final ExplosionContext damageCalculator;
    private final List<BlockPos> toBlow = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> hitPlayers = Maps.newHashMap();
    private final Explosion.Mode mode;
    private static final ExplosionContext EXPLOSION_DAMAGE_CALCULATOR = new ExplosionContext();

    public BombExplosion(World world, @Nullable Entity entity2, @Nullable DamageSource damageSource, @Nullable ExplosionContext context, double x, double y, double z, float radius, boolean blue, Explosion.Mode interaction) {
        super(world, entity2, damageSource, context, x, y, z, radius, blue, interaction);
        this.level = world;
        this.source = entity2;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blue = blue;
        this.mode = interaction;
        this.damageCalculator = context == null ? this.makeDamageCalculator(entity2) : context;
    }

    private ExplosionContext makeDamageCalculator(@Nullable Entity p_234894_1_) {
        return p_234894_1_ == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityExplosionContext(p_234894_1_);
    }

    public void doFinalizeExplosion() {
        this.level.func_184148_a(null, this.x, this.y, this.z, (SoundEvent)ModRegistry.BOMB_SOUND.get(), SoundCategory.NEUTRAL, this.blue ? 5.0f : 3.0f, 1.2f + (this.level.field_73012_v.nextFloat() - this.level.field_73012_v.nextFloat()) * 0.2f);
        ObjectArrayList drops = new ObjectArrayList();
        Collections.shuffle(this.toBlow, this.level.field_73012_v);
        for (BlockPos blockpos : this.toBlow) {
            BlockState blockstate = this.level.func_180495_p(blockpos);
            if (blockstate.isAir((IBlockReader)this.level, blockpos)) continue;
            BlockPos blockpos1 = blockpos.func_185334_h();
            this.level.func_217381_Z().func_76320_a("explosion_blocks");
            if (blockstate.canDropFromExplosion((IBlockReader)this.level, blockpos, (Explosion)this) && this.level instanceof ServerWorld) {
                TileEntity tileentity = blockstate.hasTileEntity() ? this.level.func_175625_s(blockpos) : null;
                LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.level).func_216023_a(this.level.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.source);
                if (this.mode == Explosion.Mode.DESTROY) {
                    builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.radius));
                }
                blockstate.func_215693_a(builder).forEach(p_229977_2_ -> this.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)drops, (ItemStack)p_229977_2_, blockpos1));
            }
            blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
            this.level.func_217381_Z().func_76319_b();
        }
        for (Pair pair : drops) {
            Block.func_180635_a((World)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> drops, ItemStack stack, BlockPos pos) {
        int i = drops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)drops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            drops.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!stack.func_190926_b()) continue;
            return;
        }
        drops.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        if (this.mode != Explosion.Mode.NONE) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.x;
                        double d6 = this.y;
                        double d8 = this.z;
                        float f1 = 0.3f;
                        for (float f = this.radius * (0.7f + this.level.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            FluidState fluidstate;
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            BlockState blockstate = this.level.func_180495_p(blockpos);
                            Optional optional = this.damageCalculator.func_230312_a_((Explosion)this, (IBlockReader)this.level, blockpos, blockstate, fluidstate = this.level.func_204610_c(blockpos));
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.damageCalculator.func_230311_a_((Explosion)this, (IBlockReader)this.level, blockpos, blockstate, f)) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
        }
        this.toBlow.addAll(set);
        float f2 = this.radius * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f2 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f2 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f2 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f2 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f2 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f2 + 1.0));
        List list = this.level.func_72839_b(this.source, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.level, (Explosion)this, (List)list, (double)f2);
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        for (Entity entity2 : list) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            if (entity2.func_180427_aV() || !((d12 = (double)(MathHelper.func_76133_a((double)entity2.func_195048_a(vector3d)) / f2)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity2.func_226277_ct_() - this.x) * d5 + (d7 = (entity2 instanceof TNTEntity ? entity2.func_226278_cu_() : entity2.func_226280_cw_()) - this.y) * d7 + (d9 = entity2.func_226281_cx_() - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = BombExplosion.func_222259_a((Vector3d)vector3d, (Entity)entity2);
            double d10 = (1.0 - d12) * d14;
            entity2.func_70097_a(this.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            double d11 = d10;
            boolean isPlayer = entity2 instanceof PlayerEntity;
            PlayerEntity playerentity = null;
            if (!(!isPlayer || (playerentity = (PlayerEntity)entity2).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b)) {
                this.hitPlayers.put(playerentity, new Vector3d(d5 * d10, d7 * d10, d9 * d10));
            }
            if (entity2 instanceof LivingEntity) {
                if (this.blue && (!isPlayer || !playerentity.func_175149_v() && !playerentity.func_184812_l_())) {
                    ((LivingEntity)entity2).func_195064_c(new EffectInstance(Effects.field_76437_t, 600));
                    entity2.func_70015_d(10);
                }
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity2), (double)d10);
            }
            entity2.func_213317_d(entity2.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
        }
        if (!this.level.field_72995_K) {
            for (PlayerEntity player : this.hitPlayers.keySet()) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new BombExplosionKnockbackPacket(this.hitPlayers.get(player)));
            }
        }
    }
}

